<?php

class td_js_buffer {
    static $js_header_buffer = '';
    static $js_variables_buffer = '';
    static $js_footer_buffer = ''; //js buffer for the footer
    static $js_wp_admin_buffer = ''; //js buffer that is echoed to wp-admin - it will be outputed after the variables

    static function add($js) {
        self::$js_header_buffer .= "\n" . $js;
    }

    static function add_to_wp_admin_footer($js) {
        self::$js_wp_admin_buffer .= "\n" . $js;
    }

    static function add_to_footer($js) {
        self::$js_footer_buffer .= "\n" . $js;
    }


    /**
     * @param $var string the full javascript name
     * @param $value mixed the value to assign to the javascript variable - the value is json_encode'd
     */
    static function add_variable($var, $value) {
        self::$js_variables_buffer .= "\n" .'var ' . $var . '=' . json_encode($value) . ';';
    }

    //renders the variables + custom js
    static function render() {
        return "\n<!-- JS generated by theme -->" . "\n\n<script>\n    " . apply_filters("td_js_buffer_render",  self::$js_header_buffer . self::$js_variables_buffer) . "\n</script>\n\n";
    }

    //renders the footer js
    static function render_footer() {
        return "\n<!-- JS generated by theme -->" . "\n\n<script>\n    " . apply_filters("td_js_buffer_footer_render",  self::$js_footer_buffer) . "\n</script>\n\n";
    }

    //renders only the variables - used in wp-admin
    static function render_wp_admin() {
        return "\n<!-- JS generated by theme -->" . "\n\n<script>\n    " . self::$js_variables_buffer . "\n" . self::$js_wp_admin_buffer . "\n</script>\n\n";
    }


}


function td_js_buffer_render() {
    echo td_js_buffer::render();
}

function td_js_render_wp_admin() {
    echo td_js_buffer::render_wp_admin();
}

function td_js_buffer_footer_render() {
    echo td_js_buffer::render_footer();
}

//load the entire js in front end
add_action('wp_head', 'td_js_buffer_render', 15);

//load only the variables in wp-admin
add_action('admin_footer', 'td_js_render_wp_admin', 15);


//load the footer js
add_action('wp_footer', 'td_js_buffer_footer_render', 100);