<?php

/**
 *
 * Class td_block_big_grid
 */
class td_block_big_grid extends td_block {

    const POST_LIMIT = 5;

    function render($atts, $content = null){
        $atts['limit'] = self::POST_LIMIT;

        parent::render($atts); // sets the live atts, $this->atts, $this->block_uid, $this->td_query (it runs the query)

        $buffy = ''; //output buffer

        //get the js for this block
        $buffy .= $this->get_block_js();

        $buffy .= '<div class="' . $this->get_block_classes() . '">';

            //get the block title
            $buffy .= $this->get_block_title();

            //get the sub category filter for this block
            $buffy .= $this->get_pull_down_filter();

            $buffy .= '<div id=' . $this->block_uid . ' class="td_block_inner">';
                $buffy .= $this->inner($this->td_query->posts); //inner content of the block
            $buffy .= '</div>';

            //get the ajax pagination for this block
            $buffy .= $this->get_block_pagination();
        $buffy .= '</div> <!-- ./block -->';
        $buffy .= '<div class="clearfix"></div>';
        return $buffy;
    }

    function inner($posts, $td_column_number = '') {

        $buffy = '';

        if (empty($td_column_number)) {
            $td_column_number = td_util::vc_get_column_number(); // get the column width of the block from the page builder API
        }

        //if we are on 3 columns
        //if ($td_column_number == 3) {//@todo nu merge functia td_util::vc_get_column_number()
            $td_block_layout = new td_block_layout();

            //if we have posts
            if (!empty($posts)) {

                //css fix add gradient overlay + shadow
                td_js_buffer::add_to_footer(
                    'jQuery().ready(function() {' . "\r\n" .
                    'jQuery(".td-big-grid-post .td-module-thumb a").addClass("td-image-gradient td-big-grid-overlay");' . "\r\n" .
                    '});'
                );

                $buffy .= '<div class="td-big-grid-wrapper">';

                $post_count = 0;

                foreach ($posts as $post) {

                    if ($post_count == 0) {
                        $td_module_mx5 = new td_module_mx5($post);
                        $buffy .= $td_module_mx5->render();

                        $post_count++;
                        continue;
                    }

                    $td_module_mx6 = new td_module_mx6($post);
                    $buffy .= $td_module_mx6->render($post_count);

                    $post_count++;
                }

                if ($post_count < self::POST_LIMIT) {

                    for ($i = $post_count; $i < self::POST_LIMIT; $i++) {

                        $td_module_mx_empty = new td_module_mx_empty();
                        $buffy .= $td_module_mx_empty->render($i);
                    }
                }

                $buffy .= '</div>';
            }

            $buffy .= $td_block_layout->close_all_tags();
        //}
        return $buffy;
    }
}