<?php
/**
 * This is the UI part of the social counter. 009 and 010 use different ui versions
 * User: ra
 * Date: 10/1/2014
 * Time: 11:26 AM
 */


class td_block_social_counter extends td_block {

    function render($atts, $content = null){
        parent::render($atts);

        $td_social_api = new td_social_api();

        extract(shortcode_atts(
            array(
                'icon_style' => '1', //not used
                'icon_size' => '32', //not yet used
                'custom_title' => '',
                'header_color' => '',
                'open_in_new_window' => ''
            ), $atts));

        $td_target = '';
        if (!empty($open_in_new_window)) {
            $td_target = ' target="_blank"';
        }

        $buffy = '';

        $buffy .= '<div class="' . $this->get_block_classes() . '">';
        $buffy .= $this->get_block_title();

        foreach (td_social_icons::$td_social_icons_array as $td_social_id => $td_social_name) {
            if (!empty($atts[$td_social_id])) {
                $social_network_meta = $this->get_social_network_meta($td_social_id, $atts[$td_social_id], $td_social_api);

                $buffy .= '<div class="td_social_type td-pb-margin-side td_social_' . $td_social_id . '">';
                $buffy .= '<div class="td-sp td-sp-' . $td_social_id . '"></div>';
                $buffy .= '<span class="td_social_info">' . number_format($social_network_meta['api']) . '</span>';
                $buffy .= '<span class="td_social_info td_social_info_name">' . $social_network_meta['text'] . '</span>';
                $buffy .= '<span class="td_social_button"><a href="' . $social_network_meta['url'] . '"' . $td_target . '>' .
                    $social_network_meta['button'] . '</a></span>';
                $buffy .= '</div>';
            }
        }
        $buffy .= '</div> <!-- ./block -->';

        return $buffy;
    }

    //used only on render
    function get_social_network_meta($service_id, $user_id, &$td_social_api) {
        switch ($service_id) {
            case 'facebook':
                return array(
                    'button' => __td('Like'),
                    'url' => "https://www.facebook.com/$user_id",
                    'text' => __td('Fans'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'twitter':
                return array(
                    'button' => __td('Follow'),
                    'url' => "https://twitter.com/$user_id",
                    'text' => __td('Followers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'vimeo':
                return array(
                    'button' => __td('Like'),
                    'url' => "http://vimeo.com/$user_id",
                    'text' => __td('Likes'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'youtube':
                return array(
                    'button' => __td('Subscribe'),
                    'url' => (strpos('channel/', $user_id) >= 0) ? "http://www.youtube.com/$user_id" : "http://www.youtube.com/user/$user_id",
                    'text' => __td('Subscribers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'googleplus':
                return array(
                    'button' => __td('+1'),
                    'url' => "https://plus.google.com/$user_id",
                    'text' => __td('Subscribers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'instagram':
                return array(
                    'button' => __td('Follow'),
                    'url' => "http://instagram.com/$user_id#",
                    'text' => __td('Followers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'soundcloud':
                return array(
                    'button' => __td('Follow'),
                    'url' => "https://soundcloud.com/$user_id",
                    'text' => __td('Followers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;

            case 'rss':
                return array(
                    'button' => __td('Follow'),
                    'url' => get_bloginfo('rss2_url'),
                    'text' => __td('Followers'),
                    'api' => $td_social_api->get_social_counter($service_id, $user_id),
                );
                break;
        }
    }
}


/**
 * check if the class exists, to prevent errors, better decoupling - it allows us to remove the td_block_widget class if needed
 */
if (class_exists('td_block_widget')) {

    td_global_blocks::add_lazy_shortcode('td_block_social_counter');

    //register our widget
    class td_block_social_counter_widget extends td_block_widget {
        var $td_block_id = 'td_block_social_counter'; // change only the block id, the rest is autogenerated
    }
    add_action('widgets_init', create_function('', 'return register_widget("td_block_social_counter_widget");'));
}